#pragma once

#include "SpeechCall.h"
#include "RingThread.h"
#include "ServiceSPC.h"

/////////////////////////////////////////////////////////////////////////////////////
#define WM_THREAD_RING WM_APP+1
#define WM_THREAD_STOP WM_APP+2
/////////////////////////////////////////////////////////////////////////////////////
class CRingThread;
class CServiceSPC;
////////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
/////////////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CIncomingSpeechCall :
	public CSpeechCall
{
private:
	CRingThread* mRingThread;		
	CServiceSPC* mServiceSPC;
public:	
	CIncomingSpeechCall(Bool iIsForwardedCall, CString iCallerID, CString iCallerName, int iLineID, Bool iWaiting, Bool iClipActive, Bool iExtendedFmt, Bool iCSSUenable, CConfigSPC* iCfgSPC, CServiceSPC* iSvcSPC);
	virtual ~CIncomingSpeechCall(void);
	virtual ESpcType GetType();	
protected:	
	virtual bool Release();
	virtual bool CloseLine();
	virtual bool Connect();		
	virtual bool AcceptCall();	
	virtual bool WaitingToIncoming();	
};
